using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_ModelDataChina : UserControl
    {
        public uc_ModelDataChina()
        {
            InitializeComponent();
        }
        private string path = "";


        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20191119
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina = new ModelDataInputChina();
                if (CommonClass.dicExampleConfiguration != null)
                {

                    //rbtnQuarterlyAverageDataChina.Checked = true;
                    rbtnQuarterlyAverageDataChina.Checked = true;
                    rbtnDailyAvertageDatalChina.Checked = false;
                    rbtnCMAQChina.Checked = false;
                    CommonClass.baseModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["baselineModelDataFile"];// Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_Base_Quarterly.csv";
                    txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                    CommonClass.futureModelFile = CommonClass.dicExampleConfiguration["AnnualPM"]["forecastModelDataFile"];// Application.StartupPath + @"\Data\SampleData\SMAT-China\XiAn_Model_L_R_0.5_0.5_Quarterly.csv";
                    txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
                    txtScenarioName.Text = "";
                }
            }
            else
            {
                txtScenarioName.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.scenarioName;
                rbtnCMAQChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doInputFromCMAQ;
                rbtnDailyAvertageDatalChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doDailyAverageDataInput;
                rbtnQuarterlyAverageDataChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.doQuarterlyAverageDataInput;
                CommonClass.baseModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.BaselineModelDataFile;
                txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                CommonClass.futureModelFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).modelDataInputChina.ControlModelDataFile;
                txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
            }
        }

        private void btnBaselineChina_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog open = new OpenFileDialog();
                //initial directory (1)path (2)default file (3)\Data\SampleData\
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.baseModelFile) || System.IO.Directory.Exists(CommonClass.baseModelFile))
                    {
                        open.InitialDirectory = Application.StartupPath + @"\Data\SampleData\";
                    }
                    else
                    {
                        open.InitialDirectory = Path.GetDirectoryName(CommonClass.baseModelFile);
                    }
                }
                else
                    open.InitialDirectory = path;
                open.Title = LanguageOld.Translate("Select file...");
                open.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (open.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.baseModelFile = open.FileName;
                    txtBaselineChina.Text = Path.GetFileName(open.FileName);
                    path = Path.GetDirectoryName(open.FileName);
                    open.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }            
        }

        private void btnForecastChina_Click(object sender, EventArgs e)
        {
            OpenFileDialog open = new OpenFileDialog();
            //initial directory (1)path (2)default file (3)\Data\SampleData\
            if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
            {
                if (string.IsNullOrEmpty(CommonClass.futureModelFile) || System.IO.Directory.Exists(CommonClass.futureModelFile))
                {
                    open.InitialDirectory = Application.StartupPath + @"\Data\SampleData\";
                }
                else
                {
                    open.InitialDirectory = Path.GetDirectoryName(CommonClass.futureModelFile);
                }
            }
            else
                open.InitialDirectory = path;
            open.Title = LanguageOld.Translate("Select file...");
            open.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
            if (open.ShowDialog() == DialogResult.OK)
            {
                CommonClass.futureModelFile = open.FileName;
                txtControlChina.Text = Path.GetFileName(open.FileName);
                path = Path.GetDirectoryName(open.FileName);
                open.RestoreDirectory = true;
            }
        }

        private void rbtnQuarterlyAverageDataChina_CheckedChanged(object sender, EventArgs e)
        {
            if (rbtnQuarterlyAverageDataChina.Checked == true)
            {
                CommonClass.baseModelFile = "";
                CommonClass.futureModelFile = "";
                txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
            }
            else if (rbtnDailyAvertageDatalChina.Checked == true)
            {
                CommonClass.baseModelFile = "";
                CommonClass.futureModelFile = "";
                txtBaselineChina.Text = Path.GetFileName(CommonClass.baseModelFile);
                txtControlChina.Text = Path.GetFileName(CommonClass.futureModelFile);
            }
        }
    }
}
